chrome.runtime.onInstalled.addListener(() => {
    // Parent menu
    chrome.contextMenus.create({
        id: "googleIndexedPagesParent",
        title: "indexed pages",
        contexts: ["all"]
    });

    // Time filters
    const timeFilters = [
        { id: "anyTime", title: "Any time" },
        { id: "pastHour", title: "Past hour" },
        { id: "past24Hours", title: "Past 24 hours" },
        { id: "pastWeek", title: "Past week" },
        { id: "pastMonth", title: "Past month" },
        { id: "pastYear", title: "Past year" }
    ];

    timeFilters.forEach(filter => {
        chrome.contextMenus.create({
            id: filter.id,
            parentId: "googleIndexedPagesParent",
            title: filter.title,
            contexts: ["all"]
        });
    });

    // Google + Whois menu
    chrome.contextMenus.create({
        id: "googleIndexAndWhois",
        title: "Google index and whois?",
        contexts: ["all"]
    });
});

chrome.contextMenus.onClicked.addListener(async (info, tab) => {
    // Get domain from content script
    const [{ result: domain }] = await chrome.scripting.executeScript({
        target: { tabId: tab.id },
        func: () => window.__lastRightClickDomain || ""
    });

    let finalDomain = domain;

    // Only accept valid domains
    const DOMAIN_REGEX = /^([a-z0-9-]+\.)+[a-z]{2,}$/i;
    if (!finalDomain || !DOMAIN_REGEX.test(finalDomain)) {
        // Fallback: try to get from current tab URL
        try {
            const host = new URL(tab.url).hostname.replace(/^www\./, "");
            if (DOMAIN_REGEX.test(host)) finalDomain = host;
        } catch { }
    }

    // Still invalid? Show alert and stop
    if (!finalDomain || !DOMAIN_REGEX.test(finalDomain)) {
        chrome.scripting.executeScript({
            target: { tabId: tab.id },
            func: () => alert("Please select a valid domain in the sheet or on the page.")
        });
        return;
    }

    const timeTbsMap = {
        anyTime: "",
        pastHour: "qdr:h",
        past24Hours: "qdr:d",
        pastWeek: "qdr:w",
        pastMonth: "qdr:m",
        pastYear: "qdr:y"
    };

    if (info.menuItemId in timeTbsMap) {
        const tbs = timeTbsMap[info.menuItemId];
        const url = `https://www.google.com/search?q=site:${finalDomain}${tbs ? `&tbs=${tbs}` : ""}`;
        chrome.tabs.create({ url, active: true });
        return;
    }

    if (info.menuItemId === "googleIndexAndWhois") {
        chrome.tabs.create({ url: `https://www.google.com/search?q=site:${finalDomain}`, active: true });
        chrome.tabs.create({ url: `https://www.whois.com/whois/${finalDomain}`, active: false });
        return;
    }
});

